/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UIComponent;

public class ButtonPanelVertical
extends UIComponent {
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    private int cols;
    private ButtonCol[] buttonCols;

    public ButtonPanelVertical(Button[] buttons, int anchor, int btnH, int btnsInCol) {
        int buttonsNumber = buttons.length;
        this.cols = buttonsNumber % btnsInCol > 0 ? buttonsNumber / btnsInCol + 1 : buttonsNumber / btnsInCol;
        if (anchor == 32) {
            // empty if block
        }
        this.buttonCols = new ButtonCol[this.cols];
        for (int i = 0; i < this.cols; ++i) {
            Button[] row = new Button[Math.min(buttonsNumber - i * btnsInCol, btnsInCol)];
            System.arraycopy(buttons, i * btnsInCol, row, 0, row.length);
        }
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        int btnW = w / this.cols;
        for (int i = 0; i < this.buttonCols.length; ++i) {
            this.buttonCols[i].paint(g, x0 + btnW * i, y0, btnW, h, forceInactive);
        }
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        for (int i = 0; i < this.buttonCols.length; ++i) {
            if (!this.buttonCols[i].handlePointerClicked(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IUIComponent setVisible(boolean b) {
        for (int i = 0; i < this.buttonCols.length; ++i) {
            this.buttonCols[i].setVisible(b);
        }
        this.isVisible = b;
        return this;
    }

    @Override
    public boolean canBeFocused() {
        return true;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        return false;
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
    }
}

