/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractButtonSet;
import mobileapplication3.ui.Button;

public class ButtonRow
extends AbstractButtonSet {
    private int leftSoftBindIndex = -2;
    private int rightSoftBindIndex = -2;

    public ButtonRow() {
    }

    public ButtonRow(Button[] buttons) {
        this.buttons = buttons;
    }

    public ButtonRow bindToSoftButtons() {
        return this.bindToSoftButtons(0, this.buttons.length - 1);
    }

    public ButtonRow bindToSoftButtons(int leftSoftBindIndex, int rightSoftBindIndex) {
        this.leftSoftBindIndex = leftSoftBindIndex;
        this.rightSoftBindIndex = rightSoftBindIndex;
        return this;
    }

    @Override
    public int getMinPossibleWidth() {
        int res = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            String[] btnTextLines = Utils.split(this.buttons[i].getTitle(), "\n");
            int maxLineW = 0;
            for (int j = 0; j < btnTextLines.length; ++j) {
                maxLineW = Math.max(maxLineW, Font.getDefaultFont().stringWidth(btnTextLines[j] + "    ") + this.buttons[i].getBgPagging() * 4);
            }
            res += maxLineW;
        }
        return res;
    }

    @Override
    public void onSetBounds(int x0, int y0, int w, int h) {
        if (w == -1) {
            this.w = this.getMinPossibleWidth();
        }
        if (h == -1) {
            this.h = Font.getDefaultFont().getHeight() * 5 / 2 + this.buttonsBgPadding;
        }
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        boolean wasSelected;
        if (this.buttons.length == 0) {
            return false;
        }
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        y -= this.y0;
        int i = (x -= this.x0) * this.buttons.length / this.w;
        boolean bl = wasSelected = i == this.selected && this.isSelectionEnabled;
        if (this.isSelectionEnabled) {
            this.setSelected(i);
        }
        return this.buttons[i].invokePressed(wasSelected, this.isFocused);
    }

    @Override
    protected boolean handleBindsOnKeyPressed(int keyCode) {
        switch (keyCode) {
            case -6: {
                if (this.leftSoftBindIndex != -2) {
                    return this.buttons[this.leftSoftBindIndex].invokePressed(this.selected == this.leftSoftBindIndex, this.isFocused);
                }
            }
            case -7: {
                if (this.rightSoftBindIndex == -2) break;
                return this.buttons[this.rightSoftBindIndex].invokePressed(this.selected == this.rightSoftBindIndex, this.isFocused);
            }
        }
        return super.handleBindsOnKeyPressed(keyCode);
    }

    @Override
    public boolean onKeyPressed(int keyCode, int count) {
        if (!this.isVisible) {
            return false;
        }
        switch (keyCode) {
            default: 
        }
        if (!this.isSelectionEnabled) {
            return false;
        }
        switch (RootContainer.getAction(keyCode)) {
            case 2: {
                if (this.selected > 0) {
                    this.setSelected(this.selected - 1);
                    break;
                }
                this.setSelected(this.buttons.length - 1);
                break;
            }
            case 5: {
                if (this.selected < this.buttons.length - 1) {
                    this.setSelected(this.selected + 1);
                    break;
                }
                this.setSelected(0);
                break;
            }
            case 8: {
                return this.buttons[this.selected].invokePressed(true, this.isFocused);
            }
            default: {
                return this.isFocused;
            }
        }
        if (this.isSelectionEnabled) {
            this.isSelectionVisible = true;
        }
        return true;
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.buttons == null || this.buttons.length == 0) {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            boolean drawAsSelected = i == this.selected && this.isSelectionVisible && this.isSelectionEnabled;
            this.buttons[i].paint(g, x0 + i * w / this.buttons.length, y0, w / this.buttons.length, h, drawAsSelected, this.isFocused, forceInactive, this.showKbHints);
        }
    }
}

