/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.Image;
import mobileapplication3.ui.IContainer;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UISettings;

public abstract class CanvasComponent
implements IContainer,
IUIComponent,
IPopupFeedback {
    protected int x0;
    protected int y0;
    protected int w;
    protected int h;
    protected int prevX0;
    protected int prevY0;
    protected int prevW;
    protected int prevH;
    protected int anchorX0;
    protected int anchorY0;
    protected int anchor = 20;
    protected boolean isVisible = true;
    protected boolean isFocused = true;
    protected boolean isActive = true;
    protected int pressedX;
    protected int pressedY;
    private int bgColor = 0;
    private boolean roundBg = false;
    private int padding;
    protected Image bg = null;
    private IUIComponent popupWindow = null;
    protected IContainer parent = null;
    protected boolean repaintOnlyOnFlushGraphics = false;

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public IUIComponent setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    @Override
    public IUIComponent roundBg(boolean b) {
        this.roundBg = b;
        return this;
    }

    @Override
    public IUIComponent setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public CanvasComponent setBgImage(Image bg) {
        this.bg = bg;
        return this;
    }

    public Image getCapture() {
        try {
            Image capture = Image.createImage(this.w, this.h);
            this.onPaint(capture.getGraphics(), true);
            return capture;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Image getBlurredCapture() {
        Image img = this.getCapture();
        if (img != null) {
            img.blur();
        }
        return img;
    }

    public final void showPopup(IUIComponent w) {
        this.popupWindow = w;
        this.popupWindow.setParent(this);
        this.popupWindow.init();
        this.refreshFocusedComponents();
        this.popupWindow.setSize(this.w, this.h).setPos(this.x0, this.y0, 20);
        this.repaint();
    }

    @Override
    public final void closePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.setParent(null);
        }
        this.popupWindow = null;
        this.refreshFocusedComponents();
        this.refreshSizes();
        this.repaint();
    }

    public boolean isPopupShown() {
        return this.popupWindow != null;
    }

    @Override
    public final void paint(Graphics g) {
        this.paint(g, false);
    }

    @Override
    public final void paint(Graphics g, boolean forceInactive) {
        this.paint(g, this.x0, this.y0, this.w, this.h, forceInactive);
    }

    @Override
    public final void paint(Graphics g, int x0, int y0, int w, int h) {
        this.paint(g, x0, y0, w, h, false);
    }

    @Override
    public final void paint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (!this.isVisible) {
            return;
        }
        if (w == 0 || h == 0) {
            try {
                throw new Exception("Can't paint: w=" + w + " h=" + h + " " + this.getClass().getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        forceInactive = forceInactive || !this.isActive;
        x0 += this.padding;
        y0 += this.padding;
        if ((w -= this.padding * 2) <= 0 || (h -= this.padding * 2) <= 0) {
            return;
        }
        int prevClipX = g.getClipX();
        int prevClipY = g.getClipY();
        int prevClipW = g.getClipWidth();
        int prevClipH = g.getClipHeight();
        g.setClip(x0, y0, w, h);
        this.drawBg(g, x0, y0, w, h, forceInactive);
        this.onPaint(g, x0, y0, w, h, forceInactive);
        if (this.popupWindow != null) {
            this.popupWindow.paint(g, x0, y0, w, h, forceInactive);
        }
        g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
    }

    private final void onPaint(Graphics g, boolean forceInactive) {
        this.onPaint(g, this.x0, this.y0, this.w, this.h, forceInactive);
    }

    protected abstract void onPaint(Graphics var1, int var2, int var3, int var4, int var5, boolean var6);

    protected void drawBg(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        int bgColor = !forceInactive ? this.bgColor : 0x202025;
        if (bgColor >= 0) {
            g.setColor(bgColor);
            if (this.roundBg) {
                int r = Math.min(w / 5, h / 5);
                g.fillRoundRect(x0, y0, w, h, r, r);
            } else {
                g.fillRect(x0, y0, w, h);
            }
        }
        if (this.bg != null) {
            g.drawImage(this.bg, x0 + w / 2, y0 + h / 2, 3);
        }
    }

    public final void refreshSizes() {
        this.setSize(this.w, this.h);
    }

    @Override
    public abstract boolean canBeFocused();

    @Override
    public boolean isFocused() {
        return this.isFocused;
    }

    protected final void refreshFocusedComponents() {
        if (this.popupWindow != null) {
            this.popupWindow.setFocused(true);
        }
    }

    @Override
    public IUIComponent setVisible(boolean b) {
        this.isVisible = b;
        return this;
    }

    @Override
    public IUIComponent setFocused(boolean b) {
        this.isFocused = b;
        this.refreshFocusedComponents();
        return this;
    }

    @Override
    public IUIComponent setActive(boolean b) {
        this.isActive = b;
        return this;
    }

    public boolean toggleIsVisible() {
        this.setVisible(!this.isVisible);
        return this.isVisible;
    }

    @Override
    public final boolean getIsVisible() {
        return this.isVisible;
    }

    @Override
    public final boolean repaintOnlyOnFlushGraphics() {
        return this.repaintOnlyOnFlushGraphics;
    }

    @Override
    public final boolean checkTouchEvent(int x, int y) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        if (x < this.x0 || y < this.y0) {
            return false;
        }
        return x - this.x0 <= this.w && y - this.y0 <= this.h;
    }

    @Override
    public final boolean pointerClicked(int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        if (this.popupWindow != null) {
            boolean isTarget = this.popupWindow.checkTouchEvent(x, y);
            this.popupWindow.pointerClicked(x, y);
            this.repaint();
            if (isTarget) {
                return true;
            }
        }
        return this.handlePointerClicked(x, y);
    }

    protected boolean handlePointerClicked(int x, int y) {
        return false;
    }

    @Override
    public final boolean pointerReleased(int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        if (this.popupWindow != null) {
            boolean isTarget = this.popupWindow.checkTouchEvent(x, y);
            this.popupWindow.pointerReleased(x, y);
            this.repaint();
            if (isTarget) {
                return true;
            }
        }
        return this.handlePointerReleased(x, y);
    }

    protected boolean handlePointerReleased(int x, int y) {
        return false;
    }

    @Override
    public final boolean pointerDragged(int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        if (Math.abs(x - this.pressedX) + Math.abs(y - this.pressedY) < 5) {
            return false;
        }
        if (this.popupWindow != null) {
            boolean isTarget = this.popupWindow.checkTouchEvent(x, y);
            this.popupWindow.pointerDragged(x, y);
            if (isTarget) {
                this.repaint();
                return true;
            }
        }
        return this.handlePointerDragged(x, y);
    }

    protected boolean handlePointerDragged(int x, int y) {
        return false;
    }

    @Override
    public final boolean pointerPressed(int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        this.pressedX = x;
        this.pressedY = y;
        if (this.popupWindow != null) {
            boolean isTarget = this.popupWindow.checkTouchEvent(x, y);
            this.popupWindow.pointerPressed(x, y);
            if (isTarget) {
                this.repaint();
                return true;
            }
        }
        return this.handlePointerPressed(x, y);
    }

    protected boolean handlePointerPressed(int x, int y) {
        return false;
    }

    @Override
    public final boolean mouseEvent(int event, int x, int y) {
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        if (this.popupWindow != null) {
            boolean isTarget = this.popupWindow.checkTouchEvent(x, y);
            this.popupWindow.mouseEvent(event, x, y);
            this.repaint();
            if (isTarget) {
                return true;
            }
        }
        return this.handleMouseEvent(event, x, y);
    }

    public boolean handleMouseEvent(int event, int x, int y) {
        return false;
    }

    @Override
    public final boolean keyPressed(int keyCode, int count) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        if (this.popupWindow != null) {
            this.popupWindow.keyPressed(keyCode, count);
            this.repaint();
            return true;
        }
        return this.handleKeyPressed(keyCode, count);
    }

    protected boolean handleKeyPressed(int keyCode, int count) {
        return false;
    }

    @Override
    public final boolean keyReleased(int keyCode, int count) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        if (this.popupWindow != null) {
            this.popupWindow.keyReleased(keyCode, count);
            this.repaint();
            return true;
        }
        return this.handleKeyReleased(keyCode, count);
    }

    protected boolean handleKeyReleased(int keyCode, int count) {
        return false;
    }

    @Override
    public final boolean keyRepeated(int keyCode, int pressedCount) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        if (this.popupWindow != null) {
            this.popupWindow.keyRepeated(keyCode, pressedCount);
            this.repaint();
            return true;
        }
        return this.handleKeyRepeated(keyCode, pressedCount);
    }

    protected boolean handleKeyRepeated(int keyCode, int pressedCount) {
        return false;
    }

    @Override
    public void onShow() {
    }

    @Override
    public void onHide() {
    }

    public final IUIComponent setPos(int x0, int y0) {
        this.x0 = x0;
        this.y0 = y0;
        return this;
    }

    @Override
    public final IUIComponent setPos(int x0, int y0, int anchor) {
        this.anchorX0 = x0;
        this.anchorY0 = y0;
        this.anchor = anchor;
        if ((anchor & 8) != 0) {
            x0 -= this.w;
        } else if ((anchor & 1) != 0) {
            x0 -= this.w / 2;
        }
        if ((anchor & 0x20) != 0) {
            y0 -= this.h;
        } else if ((anchor & 2) != 0) {
            y0 -= this.h / 2;
        }
        this.setPos(x0, y0);
        this.setBounds(x0, y0, this.w, this.h);
        return this;
    }

    @Override
    public final IUIComponent setSize(int w, int h) {
        if (this.w == w && this.h == h || w == 0 || h == 0) {
            return this;
        }
        this.setBounds(this.x0, this.y0, w, h);
        this.setPos(this.anchorX0, this.anchorY0, this.anchor);
        return this;
    }

    private final void setBounds(int x0, int y0, int w, int h) {
        if (w == 0 || h == 0) {
            try {
                throw new Exception("Setting zero as a dimension " + this.getClass().getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (x0 == this.prevX0 && y0 == this.prevY0 && w == this.prevW && h == this.prevH) {
            return;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setSize(w, h).setPos(x0, y0, 20);
        }
        if (this.prevW != 0 && this.prevH != 0 && w != this.prevW && h != this.prevH) {
            this.bg = null;
            if (this.bgColor == -1) {
                this.bgColor = 0;
            }
        }
        this.prevW = this.w = w;
        this.prevH = this.h = h;
        this.prevX0 = this.x0 = x0;
        this.prevY0 = this.y0 = y0;
        this.onSetBounds(x0, y0, w, h);
    }

    @Override
    public final IUIComponent setParent(IContainer parent) {
        this.parent = parent;
        return this;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public UISettings getUISettings() {
        if (this.hasParent()) {
            return this.parent.getUISettings();
        }
        try {
            throw new IllegalStateException(this.getClass().getName() + " has no parent and can't get UI settings");
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public final void repaint() {
        if (!this.isVisible) {
            return;
        }
        if (this.parent != null) {
            this.parent.repaint();
        } else {
            try {
                throw new NullPointerException("Can't call parent's repaint: parent component is not set! " + this.getClass().getName());
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public final Graphics getUGraphics() {
        if (this.parent != null) {
            return this.parent.getUGraphics();
        }
        try {
            throw new NullPointerException("Can't call parent's getGraphics: parent component is not set! " + this.getClass().getName());
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public final void flushGraphics() {
        if (this.parent != null) {
            this.parent.flushGraphics();
        } else {
            try {
                throw new NullPointerException("Can't call parent's getGraphics: parent component is not set! " + this.getClass().getName());
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean isOnScreen() {
        return this.hasParent() && this.parent.isOnScreen();
    }

    protected abstract void onSetBounds(int var1, int var2, int var3, int var4);
}

