/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AbstractButtonSet;
import mobileapplication3.ui.AnimationThread;
import mobileapplication3.ui.IContainer;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UIComponent;

public class Grid
extends UIComponent
implements IContainer {
    public static final int H_AUTO = -1;
    public IUIComponent[] elements = null;
    private int cols = 1;
    protected int bgColor = -1;
    protected int elementsBgColor = -2;
    protected int elementsPadding = 0;
    protected int selected = 0;
    protected int prevSelected = 0;
    protected boolean isSelectionEnabled = true;
    protected boolean isSelectionVisible = false;
    protected boolean selectedOutOfRange = false;
    private AnimationThread animationThread = null;
    private int elemW;
    private int elemH = -1;
    private boolean isScrollable = true;
    private boolean trimHeight = true;
    private boolean autoElemH = false;
    private int hBeforeTrim;
    private int prevTotalelemsH;
    private int scrollOffset = 0;
    protected int pointerPressedX;
    protected int pointerPressedY;
    protected int scrollOffsetWhenPressed;
    protected int lastDraggedY;
    protected int lastDraggedDY;
    protected int draggedAvgDY;
    protected long lastDraggedT;
    protected int lastDraggedDT;
    protected int draggedAvgDT;
    private boolean startFromBottom;
    private boolean kbSmoothScrolling = true;
    private boolean kineticTouchScrolling = true;
    private boolean isInited = false;
    protected boolean ignoreKeyRepeated = true;

    public Grid() {
    }

    public Grid(IUIComponent[] elements) {
        this.elements = elements;
    }

    @Override
    public void init() {
        try {
            this.ignoreKeyRepeated = !this.getUISettings().getKeyRepeatedInListsEnabled();
            this.isSelectionVisible = this.getUISettings().showKbHints();
            this.kbSmoothScrolling = this.getUISettings().getKbSmoothScrollingEnabled();
            this.kineticTouchScrolling = this.getUISettings().getKineticTouchScrollingEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isInited = true;
        this.setElements(this.elements);
    }

    @Override
    public void recalcSize() {
        this.setSizes(this.w, this.hBeforeTrim, this.elemH, this.trimHeight);
    }

    public Grid setCols(int cols) {
        this.cols = cols;
        return this;
    }

    @Override
    public IUIComponent setSize(int w, int h) {
        return this.setSizes(w, h, this.elemH);
    }

    public IUIComponent setSizes(int w, int h, int elemH) {
        return this.setSizes(w, h, elemH, this.trimHeight);
    }

    public IUIComponent setSizes(int w, int h, int elemH, boolean trimHeight) {
        if (w == 0 || h == 0 || elemH == 0) {
            try {
                throw new Exception("Setting zero as a dimension " + this.getClass().getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this;
            }
        }
        int prevH = this.h;
        this.w = w;
        this.h = h;
        this.elemH = elemH;
        this.hBeforeTrim = this.h;
        this.trimHeight = trimHeight;
        boolean bl = this.autoElemH = this.autoElemH || this.elemH == -1;
        if (this.elements == null) {
            return this;
        }
        this.elemW = w / this.cols;
        if (this.autoElemH) {
            this.elemH = this.elemW;
        }
        if (this.h == -1) {
            this.h = this.getTotalElemsH();
        }
        if (this.trimHeight) {
            this.h = Math.min(this.h, this.getTotalElemsH());
        }
        if (this.startFromBottom) {
            int dteh = this.getTotalElemsH() - this.prevTotalelemsH;
            int dh = this.h - prevH;
            this.prevTotalelemsH = this.getTotalElemsH();
            this.scrollOffset += dteh - dh;
            this.setSelected(this.elements.length - 1);
        }
        this.scrollOffsetWhenPressed = this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.getTotalElemsH() - this.h));
        this.recalcPos();
        return super.setSize(this.w, this.h);
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].setSize(w, this.elemH).setPos(x0, y0 + i * this.elemH, 20);
        }
    }

    public int getElemH() {
        return this.elemH;
    }

    public int getRowsCount() {
        if (this.elements == null) {
            return 0;
        }
        int c = this.elements.length / this.cols;
        if (this.elements.length % this.cols != 0) {
            ++c;
        }
        return c;
    }

    public int getTotalElemsH() {
        return this.getRowsCount() * this.getElemH();
    }

    @Override
    public boolean handleMouseEvent(int event, int x, int y) {
        int scrollOffset = this.scrollOffset;
        if (event == 7) {
            scrollOffset += this.h / 5;
        } else if (event == -7) {
            scrollOffset -= this.h / 5;
        } else {
            return false;
        }
        if (this.kbSmoothScrolling && scrollOffset != this.scrollOffset) {
            this.initAnimationThread();
            this.animationThread.animate(0, this.scrollOffset, 0, scrollOffset, 200, 0, 0, 0, this.getTotalElemsH() - this.h);
        } else {
            this.scrollOffset = Math.max(0, Math.min(scrollOffset, this.getTotalElemsH() - this.h));
        }
        return true;
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        this.prevSelected = this.selected;
        int selected = (y - this.y0 + this.scrollOffset) / this.elemH * this.cols + x / this.elemW;
        boolean bl = this.selectedOutOfRange = selected >= this.elements.length;
        if (!this.selectedOutOfRange) {
            this.setSelected(selected);
            this.elements[selected].pointerPressed(x, y);
        }
        return !this.selectedOutOfRange && this.elements[selected].pointerClicked(x, y);
    }

    @Override
    protected boolean handlePointerReleased(int x, int y) {
        int startY = this.scrollOffset;
        int targetY = this.scrollOffset;
        int dY = this.draggedAvgDT > 0 ? this.draggedAvgDY * this.draggedAvgDY * 350 / this.draggedAvgDT / this.draggedAvgDT : 0;
        int topLimitY = 0;
        int bottomLimitY = this.getTotalElemsH() - this.h;
        if (this.kineticTouchScrolling && (targetY -= dY * Mathh.sign(this.draggedAvgDY)) != startY) {
            this.initAnimationThread();
            int t = Math.min(2000, Math.abs(2 * dY * this.draggedAvgDT / this.draggedAvgDY));
            this.animationThread.animate(0, startY, 0, targetY, t, 0, 0, topLimitY, bottomLimitY, this.draggedAvgDT);
        } else {
            this.scrollOffset = Mathh.constrain(topLimitY, targetY, bottomLimitY);
        }
        return true;
    }

    @Override
    public boolean handlePointerPressed(int x, int y) {
        this.stopAnimation();
        if (!this.isVisible) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (!this.isScrollable) {
            return false;
        }
        if (!this.checkTouchEvent(x, y)) {
            this.pointerPressedY = -1;
            this.pointerPressedX = -1;
            return false;
        }
        this.pointerPressedX = x;
        this.pointerPressedY = y;
        this.scrollOffsetWhenPressed = this.scrollOffset;
        this.lastDraggedY = y;
        this.lastDraggedT = System.currentTimeMillis();
        this.draggedAvgDY = 0;
        this.draggedAvgDT = 0;
        return true;
    }

    @Override
    public boolean handlePointerDragged(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (!this.isScrollable) {
            return false;
        }
        if (!this.selectedOutOfRange && this.elements[this.selected].pointerDragged(x, y)) {
            return true;
        }
        this.scrollOffset = this.scrollOffsetWhenPressed - (y - this.pointerPressedY);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.getTotalElemsH() - this.h));
        this.lastDraggedDY = y - this.lastDraggedY;
        this.lastDraggedY = y;
        this.lastDraggedDT = (int)(System.currentTimeMillis() - this.lastDraggedT);
        this.lastDraggedT = System.currentTimeMillis();
        this.draggedAvgDY = this.draggedAvgDY == 0 ? this.lastDraggedDY : (2 * this.draggedAvgDY + 2 * this.lastDraggedDY + 1) / 4;
        this.draggedAvgDT = this.draggedAvgDT == 0 ? this.lastDraggedDT : (2 * this.draggedAvgDT + 2 * this.lastDraggedDT + 1) / 4;
        return true;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        if (!this.isVisible) {
            return false;
        }
        if (!this.isSelectionEnabled) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (this.handleKeyPressedScrollOnly(keyCode, count, false)) {
            return true;
        }
        return this.elements[this.selected].keyPressed(keyCode, count);
    }

    private boolean handleKeyPressedScrollOnly(int keyCode, int count, boolean isKeyRepeated) {
        if (this.ignoreKeyRepeated && isKeyRepeated) {
            return false;
        }
        switch (keyCode) {
            default: 
        }
        switch (RootContainer.getAction(keyCode)) {
            case 2: {
                if (this.selected > 0) {
                    this.setSelected(this.selected - 1);
                    break;
                }
                this.setSelected(this.elements.length - 1);
                break;
            }
            case 5: {
                if (this.selected < this.elements.length - 1) {
                    this.setSelected(this.selected + 1);
                    break;
                }
                this.setSelected(0);
                break;
            }
            case 1: {
                if (this.selected > this.cols - 1) {
                    this.setSelected(this.selected - this.cols);
                    break;
                }
                int i = this.elements.length / this.cols * this.cols + this.selected % this.cols;
                if (i < this.elements.length) {
                    this.setSelected(i);
                    break;
                }
                this.setSelected(i - this.cols);
                break;
            }
            case 6: {
                if (this.selected < this.elements.length - this.cols) {
                    this.setSelected(this.selected + this.cols);
                    break;
                }
                this.setSelected(this.selected % this.cols);
                break;
            }
            default: {
                return false;
            }
        }
        int selectedY = this.selected / this.cols * this.elemH;
        int startY = this.scrollOffset;
        int targetY = this.scrollOffset;
        if (this.elemH * 2 < this.h) {
            if (selectedY < this.scrollOffset) {
                targetY = selectedY - this.elemH * 3 / 4;
            }
            if (selectedY + this.elemH > this.scrollOffset + this.h) {
                targetY = selectedY - this.h + this.elemH + this.elemH * 3 / 4;
            }
        } else {
            targetY = selectedY - this.h / 2 + this.elemH / 2;
        }
        int topLimitY = 0;
        int bottomLimitY = this.getTotalElemsH() - this.h;
        if (this.kbSmoothScrolling && targetY != startY) {
            this.initAnimationThread();
            this.animationThread.animate(0, startY, 0, targetY, 200, 0, 0, topLimitY, bottomLimitY);
        }
        if (this.isSelectionEnabled) {
            this.isSelectionVisible = true;
        }
        return true;
    }

    public Grid enableScrolling(boolean isScrollable, boolean startFromBottom) {
        this.startFromBottom = startFromBottom;
        if (isScrollable) {
            this.setIsSelectionEnabled(true);
        }
        this.isScrollable = isScrollable;
        return this;
    }

    public Grid trimHeight(boolean b) {
        this.trimHeight = b;
        return this;
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.elements == null || this.elements.length == 0) {
            return;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Font prevFont = g.getFont();
            int elemW = this.elemW - this.elementsPadding * 2;
            int elemH = this.elemH - this.elementsPadding * 2;
            int cellX = i % this.cols;
            int cellY = i / this.cols;
            int elemX = x0 + cellX * this.elemW + this.elementsPadding;
            int elemY = y0 - this.scrollOffset + cellY * this.elemH + this.elementsPadding;
            int bottomY = y0 + h;
            if (elemY + elemH < y0) continue;
            if (elemY > y0 + h) break;
            boolean drawAsSelected = i == this.selected && this.isSelectionVisible && this.isFocused;
            this.drawBgUnderElement(g, elemX, elemY, elemW, elemH, !forceInactive, drawAsSelected);
            this.elements[i].paint(g, elemX, elemY, elemW, elemH, forceInactive);
            g.setFont(prevFont);
            if (!drawAsSelected) continue;
            g.setColor(0xFFFFFF);
            int markY0 = elemH / 2 - Font.getDefaultFontHeight() / 2;
            int markY1 = elemH - markY0;
            int markCenterY = (markY0 + markY1) / 2;
            int markw = (markY1 - markY0) / 2;
            g.fillTriangle(elemX + 1, elemY + markY0, elemX + 1, elemY + markY1, elemX + markw, elemY + markCenterY);
            g.fillTriangle(elemX + elemW - 1, elemY + markY0, elemX + elemW - 1, elemY + markY1, elemX + elemW - markw, elemY + markCenterY);
        }
        if (this.isSelectionEnabled && !forceInactive && h < this.getTotalElemsH()) {
            g.setColor(0xFFFFFF);
            int selectionMarkY0 = h * this.scrollOffset / this.getTotalElemsH();
            int selectionMarkY1 = h * (this.scrollOffset + h) / this.getTotalElemsH();
            g.drawLine(x0 + w - 1, y0 + selectionMarkY0, x0 + w - 1, y0 + selectionMarkY1);
        }
    }

    protected void drawBgUnderElement(Graphics g, int x0, int y0, int w, int h, boolean isActive, boolean isSelected) {
        if (isActive) {
            if (isSelected) {
                g.setColor(85);
            } else {
                g.setColor(0x101020);
            }
        } else {
            g.setColor(0x202025);
        }
        int d = Math.min(w / 5, h / 5);
        g.fillRoundRect(x0, y0, w, h, d, d);
    }

    private void initAnimationThread() {
        if (this.animationThread == null) {
            this.animationThread = new AnimationThread(new AnimationThread.AnimationWorker(){

                @Override
                public void onStep(int newX, int newY) {
                    Grid.this.scrollOffset = newY;
                    Grid.this.repaint();
                }
            });
        }
    }

    private void stopAnimation() {
        if (this.animationThread != null) {
            this.animationThread.stop();
        }
    }

    public Grid setElements(IUIComponent[] elements) {
        this.elements = elements;
        if (!this.isInited || elements == null) {
            return this;
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i].setParent(this);
            elements[i].init();
            elements[i].setBgColor(-1);
            if (!(elements[i] instanceof AbstractButtonSet)) continue;
            ((AbstractButtonSet)elements[i]).setIsSelectionEnabled(true);
        }
        this.setElementsPadding(this.elementsPadding);
        this.setIsSelectionEnabled(this.isSelectionEnabled);
        if (this.isSizeSet()) {
            this.recalcSize();
        }
        return this;
    }

    public Grid setElementsBgColor(int color) {
        if (color == -2) {
            return this;
        }
        this.elementsBgColor = color;
        if (this.elements == null) {
            return this;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].setBgColor(color);
        }
        return this;
    }

    public Grid setElementsPadding(int padding) {
        this.elementsPadding = padding;
        if (this.elements == null) {
            return this;
        }
        for (int i = 0; i < this.elements.length; ++i) {
        }
        return this;
    }

    public Grid setIsSelectionEnabled(boolean selectionEnabled) {
        this.isSelectionEnabled = selectionEnabled;
        return this;
    }

    public Grid setIsSelectionVisible(boolean isSelectionVisible) {
        this.isSelectionVisible = isSelectionVisible;
        return this;
    }

    public Grid setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public int getSelected() {
        return this.selected;
    }

    public int getElementCount() {
        if (this.elements != null) {
            return this.elements.length;
        }
        return 0;
    }

    @Override
    public boolean canBeFocused() {
        if (this.elements == null) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null || !this.elements[i].canBeFocused()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        if (this.handleKeyPressedScrollOnly(keyCode, 1, true)) {
            return true;
        }
        return this.elements[this.selected].keyRepeated(keyCode, pressedCount) || this.isFocused;
    }
}

