/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.AnimationThread;
import mobileapplication3.ui.IContainer;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UIComponent;

public class List
extends UIComponent
implements IContainer {
    public static final int H_AUTO = -1;
    public IUIComponent[] elements = null;
    protected int bgColor = -1;
    protected int elementsBgColor = -2;
    protected int elementsPadding = 0;
    protected int selected = 0;
    protected int prevSelected = 0;
    protected boolean isSelectionEnabled = true;
    protected boolean isSelectionVisible = false;
    private AnimationThread animationThread = null;
    private int elemH = -1;
    private boolean isScrollable = true;
    private boolean trimHeight = true;
    private int hUntilTrim;
    private int prevTotalelemsH;
    private int scrollOffset = 0;
    protected int pointerPressedX;
    protected int pointerPressedY;
    protected int scrollOffsetWhenPressed;
    private boolean startFromBottom = false;
    private boolean enableAnimations = true;
    private boolean isInited = false;
    protected boolean ignoreKeyRepeated = true;

    public List() {
    }

    public List(IUIComponent[] elements) {
        this.elements = elements;
    }

    @Override
    public void init() {
        try {
            this.ignoreKeyRepeated = !this.getUISettings().getKeyRepeatedInListsEnabled();
            this.isSelectionVisible = this.isSelectionVisible || this.getUISettings().showKbHints();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isInited = true;
        this.setElements(this.elements);
    }

    @Override
    public void recalcSize() {
        this.setSizes(this.w, this.hUntilTrim, this.elemH, this.trimHeight);
    }

    @Override
    public IUIComponent setSize(int w, int h) {
        return this.setSizes(w, h, this.elemH);
    }

    public IUIComponent setSizes(int w, int h, int elemH) {
        return this.setSizes(w, h, elemH, this.trimHeight);
    }

    public IUIComponent setSizes(int w, int h, int elemH, boolean trimHeight) {
        if (w == 0 || h == 0 || elemH == 0) {
            try {
                throw new Exception("Setting zero as a dimension " + this.getClass().getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this;
            }
        }
        int prevH = this.h;
        this.w = w;
        this.h = h;
        this.elemH = elemH;
        this.hUntilTrim = this.h;
        this.trimHeight = trimHeight;
        if (this.elements == null) {
            return this;
        }
        if (this.elemH == -1) {
            this.elemH = Font.getDefaultFont().getHeight() * 5 / 2 + this.elementsPadding * 2;
            if (this.h != -1 && !this.trimHeight) {
                this.elemH = Math.max(this.elemH, this.h / this.elements.length);
            }
        } else {
            this.h = Math.min(this.h, this.elemH * this.elements.length);
        }
        if (this.h == -1) {
            this.h = this.elements.length * this.elemH;
        }
        if (this.trimHeight) {
            this.h = Math.min(this.h, this.elemH * this.elements.length);
        }
        if (this.startFromBottom) {
            int dteh = this.getTotalElemsH() - this.prevTotalelemsH;
            int dh = this.h - prevH;
            this.prevTotalelemsH = this.getTotalElemsH();
            this.scrollOffset += dteh - dh;
            this.setSelected(this.elements.length - 1);
        }
        this.scrollOffsetWhenPressed = this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.getTotalElemsH() - this.h));
        this.recalcPos();
        return super.setSize(this.w, this.h);
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].setSize(w, this.elemH).setPos(x0, y0 + i * this.elemH, 20);
        }
    }

    public int getElemH() {
        return this.elemH;
    }

    public int getTotalElemsH() {
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length * this.getElemH();
    }

    @Override
    public boolean handleMouseEvent(int event, int x, int y) {
        int scrollOffset = this.scrollOffset;
        if (event == 7) {
            scrollOffset += this.h / 5;
        } else if (event == -7) {
            scrollOffset -= this.h / 5;
        } else {
            return false;
        }
        if (this.enableAnimations && scrollOffset != this.scrollOffset) {
            this.initAnimationThread();
            this.animationThread.animate(0, this.scrollOffset, 0, scrollOffset, 200, 0, 0, 0, this.elemH * this.elements.length - this.h);
        } else {
            this.scrollOffset = Math.max(0, Math.min(scrollOffset, this.getTotalElemsH() - this.h));
        }
        return true;
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (!this.checkTouchEvent(x, y)) {
            return false;
        }
        this.prevSelected = this.selected;
        return this.elements[this.selected].pointerClicked(x, y);
    }

    @Override
    public boolean handlePointerPressed(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (!this.isScrollable) {
            return false;
        }
        if (this.elemH * this.elements.length <= this.h) {
            // empty if block
        }
        if (!this.checkTouchEvent(x, y)) {
            this.pointerPressedY = -1;
            this.pointerPressedX = -1;
            return false;
        }
        this.pointerPressedX = x;
        this.pointerPressedY = y;
        this.scrollOffsetWhenPressed = this.scrollOffset;
        this.setSelected((y - this.y0 + this.scrollOffset) / this.elemH);
        this.elements[this.selected].pointerPressed(x, y);
        return true;
    }

    @Override
    public boolean handlePointerDragged(int x, int y) {
        if (!this.isVisible) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (!this.isScrollable) {
            return false;
        }
        if (this.elemH * this.elements.length <= this.h) {
            // empty if block
        }
        if (this.elements[this.selected].pointerDragged(x, y)) {
            return true;
        }
        this.scrollOffset = this.scrollOffsetWhenPressed - (y - this.pointerPressedY);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.getTotalElemsH() - this.h));
        return true;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        if (!this.isVisible) {
            return false;
        }
        if (!this.isSelectionEnabled) {
            return false;
        }
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (this.handleKeyPressedScrollOnly(keyCode, count, false)) {
            return true;
        }
        return this.elements[this.selected].keyPressed(keyCode, count);
    }

    private boolean handleKeyPressedScrollOnly(int keyCode, int count, boolean isKeyRepeated) {
        if (this.ignoreKeyRepeated && isKeyRepeated) {
            return false;
        }
        switch (keyCode) {
            default: 
        }
        switch (RootContainer.getAction(keyCode)) {
            case 1: {
                if (this.selected > 0) {
                    this.setSelected(this.selected - 1);
                    break;
                }
                this.setSelected(this.elements.length - 1);
                break;
            }
            case 6: {
                if (this.selected < this.elements.length - 1) {
                    this.setSelected(this.selected + 1);
                    break;
                }
                this.setSelected(0);
                break;
            }
            default: {
                return false;
            }
        }
        int selectedY = this.elemH * this.selected;
        int startY = this.scrollOffset;
        int targetY = this.scrollOffset;
        int topLimitY = 0;
        int bottomLimitY = this.elemH * this.elements.length - this.h;
        if (this.elemH * 2 < this.h) {
            if (selectedY < this.scrollOffset) {
                targetY = Math.max(topLimitY, selectedY - this.elemH * 3 / 4);
            }
            if (selectedY + this.elemH > this.scrollOffset + this.h) {
                targetY = Math.min(bottomLimitY, selectedY - this.h + this.elemH + this.elemH * 3 / 4);
            }
        } else {
            targetY = selectedY - this.h / 2 + this.elemH / 2;
        }
        if (this.enableAnimations && targetY != startY) {
            this.initAnimationThread();
            this.animationThread.animate(0, startY, 0, targetY, 200, 0, 0, topLimitY, bottomLimitY);
        } else {
            this.scrollOffset = targetY;
        }
        if (this.isSelectionEnabled) {
            this.isSelectionVisible = true;
        }
        return true;
    }

    public List enableScrolling(boolean isScrollable, boolean startFromBottom) {
        this.startFromBottom = startFromBottom;
        if (isScrollable) {
            this.setIsSelectionEnabled(true);
        }
        this.isScrollable = isScrollable;
        return this;
    }

    public List enableAnimations(boolean b) {
        this.enableAnimations = b;
        return this;
    }

    public List trimHeight(boolean b) {
        this.trimHeight = b;
        return this;
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.elements == null || this.elements.length == 0) {
            return;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Font prevFont = g.getFont();
            int elemH = this.elemH;
            int elemY = y0 - this.scrollOffset + i * elemH;
            if (elemY + elemH < y0) continue;
            if (elemY > y0 + h) break;
            boolean drawAsSelected = i == this.selected && this.isSelectionVisible && this.isFocused;
            this.drawBgUnderElement(g, x0, elemY, w, elemH, !forceInactive, drawAsSelected);
            this.elements[i].paint(g, x0, elemY, w, elemH, forceInactive);
            g.setFont(prevFont);
            if (!drawAsSelected) continue;
            int markY0 = elemH / 3;
            int markY1 = elemH - markY0;
            int markCenterY = (markY0 + markY1) / 2;
            int markw = (markY1 - markY0) / 2;
            g.fillTriangle(x0 + 1, elemY + markY0, x0 + 1, elemY + markY1, x0 + markw, elemY + markCenterY);
            g.fillTriangle(x0 + w - 1, elemY + markY0, x0 + w - 1, elemY + markY1, x0 + w - markw, elemY + markCenterY);
        }
        if (this.isSelectionEnabled && !forceInactive && h < this.getTotalElemsH()) {
            g.setColor(0xFFFFFF);
            int selectionMarkY0 = h * this.scrollOffset / this.getTotalElemsH();
            int selectionMarkY1 = h * (this.scrollOffset + h) / this.getTotalElemsH();
            g.drawLine(x0 + w - 1, y0 + selectionMarkY0, x0 + w - 1, y0 + selectionMarkY1);
        }
    }

    protected void drawBgUnderElement(Graphics g, int x0, int y0, int w, int h, boolean isActive, boolean isSelected) {
        if (isActive) {
            if (isSelected) {
                g.setColor(85);
            } else {
                g.setColor(0x101020);
            }
        } else {
            g.setColor(0x202025);
        }
        int d = Math.min(w / 5, h / 5);
        g.fillRoundRect(x0, y0, w, h, d, d);
    }

    private void initAnimationThread() {
        if (this.animationThread == null) {
            this.animationThread = new AnimationThread(new AnimationThread.AnimationWorker(){

                @Override
                public void onStep(int newX, int newY) {
                    List.this.scrollOffset = newY;
                    List.this.repaint();
                }
            });
        }
    }

    public List setElements(IUIComponent[] elements) {
        this.elements = elements;
        if (!this.isInited || elements == null) {
            return this;
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i].setParent(this);
            elements[i].init();
            elements[i].setBgColor(-1);
        }
        this.setElementsPadding(this.elementsPadding);
        this.setIsSelectionEnabled(this.isSelectionEnabled);
        if (this.isSizeSet()) {
            this.recalcSize();
        }
        return this;
    }

    public List setElementsBgColor(int color) {
        if (color == -2) {
            return this;
        }
        this.elementsBgColor = color;
        if (this.elements == null) {
            return this;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].setBgColor(color);
        }
        return this;
    }

    public List setElementsPadding(int padding) {
        this.elementsPadding = padding;
        if (this.elements == null) {
            return this;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].setPadding(padding);
        }
        return this;
    }

    public List setIsSelectionEnabled(boolean selectionEnabled) {
        this.isSelectionEnabled = selectionEnabled;
        return this;
    }

    public List setIsSelectionVisible(boolean isSelectionVisible) {
        this.isSelectionVisible = isSelectionVisible;
        return this;
    }

    public List setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public int getSelected() {
        return this.selected;
    }

    public int getElementCount() {
        if (this.elements != null) {
            return this.elements.length;
        }
        return 0;
    }

    @Override
    public boolean canBeFocused() {
        if (this.elements == null) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null || !this.elements[i].canBeFocused()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleKeyRepeated(int keyCode, int pressedCount) {
        if (this.handleKeyPressedScrollOnly(keyCode, 1, true)) {
            return true;
        }
        return this.elements[this.selected].keyRepeated(keyCode, pressedCount) || this.isFocused;
    }
}

