/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonRow;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.TextComponent;

public abstract class Page
extends Container {
    protected TextComponent title = null;
    protected IUIComponent pageContent = null;
    protected ButtonRow actionButtons;
    protected int margin;
    protected boolean isInited = false;

    public Page(String title) {
        this.title = new TextComponent(title);
        this.actionButtons = new ButtonRow(){

            @Override
            public boolean canBeFocused() {
                return false;
            }
        };
    }

    @Override
    public void init() {
        if (!this.isInited) {
            this.isInited = true;
            this.pageContent = this.initAndGetPageContent();
            this.actionButtons.setButtons(this.getActionButtons());
            this.actionButtons.bindToSoftButtons(0, this.actionButtons.getButtonCount() - 1);
            this.actionButtons.setFocused(false);
        }
        this.setComponents(new IUIComponent[]{this.title, this.pageContent, this.actionButtons});
    }

    @Override
    public boolean keyPressed(int keyCode, int count) {
        return super.keyPressed(keyCode, count);
    }

    @Override
    public final void onSetBounds(int x0, int y0, int w, int h) {
        if (!this.isInited) {
            try {
                throw new IllegalStateException("Error: init() hadn't done! " + this.getClass().getName());
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
        }
        this.margin = h / 32;
        this.title.setSize(w, -1).setPos(x0, y0, 20);
        this.actionButtons.setButtonsBgPadding(this.margin / 4).setSize(w, -1).setPos(x0 + w / 2, y0 + h, 33);
        this.setPageContentBounds(this.pageContent, x0, this.title.getBottomY(), w, this.actionButtons.getTopY() - this.title.getBottomY());
    }

    protected void setPageContentBounds(IUIComponent pageContent, int x0, int y0, int w, int h) {
        if (pageContent != null) {
            pageContent.setSize(w - this.margin * 2, h - this.margin * 2).setPos(x0 + w / 2, y0 + h - this.margin, 33);
        }
    }

    public Page setTitle(String title) {
        this.title.setText(title);
        return this;
    }

    protected abstract Button[] getActionButtons();

    protected abstract IUIComponent initAndGetPageContent();
}

