/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonRow;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.Property;
import mobileapplication3.ui.TextComponent;

public class Slider
extends Container {
    private TextComponent title;
    private TextComponent valueIndicator;
    private ButtonRow buttonRow;
    private Property prop;
    private short value;
    private short minValue;
    private short maxValue;
    private int prevDraggedX;
    private long prevDraggedTime = 0L;

    public Slider(Property prop) {
        this.minValue = prop.getMinValue();
        this.maxValue = prop.getMaxValue();
        this.title = new TextComponent(prop.getName());
        this.title.setBgColor(-1);
        this.value = prop.getValue();
        this.valueIndicator = new TextComponent(String.valueOf(this.value));
        this.valueIndicator.setBgColor(-1);
        this.buttonRow = new ButtonRow();
        this.buttonRow.setBgColor(-1);
        this.buttonRow.setButtonsBgColor(-1);
        this.buttonRow.setButtonsBgColorInactive(-1);
        this.buttonRow.setButtons(new Button[]{new Button("-"){

            @Override
            public void buttonPressed() {
                Slider.this.setValue((short)(Slider.this.getValue() - 1));
            }
        }, new Button("+"){

            @Override
            public void buttonPressed() {
                Slider.this.setValue((short)(Slider.this.getValue() + 1));
            }
        }});
        this.setBgColor(85);
        this.setActive(!prop.isCalculated());
        this.roundBg(true);
        this.prop = prop;
    }

    @Override
    public void init() {
        this.setComponents(new IUIComponent[]{this.title, this.valueIndicator, this.buttonRow});
    }

    @Override
    protected void drawBg(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        boolean isActive = this.isActive && !forceInactive;
        int prevClipX = g.getClipX();
        int prevClipY = g.getClipY();
        int prevClipW = g.getClipWidth();
        int prevClipH = g.getClipHeight();
        int sliderFilledW = w * (this.value - this.minValue) / (this.maxValue - this.minValue);
        int roundingD = Math.min(w / 5, h / 5);
        if (isActive) {
            g.setColor(0x101020);
        } else {
            g.setColor(0x202025);
        }
        int clipX = x0;
        int clipY = y0;
        int clipW = w;
        int clipH = h;
        int clipX2 = clipX + clipW;
        int clipY2 = clipY + clipH;
        clipX = Math.max(clipX, prevClipX);
        clipY = Math.max(clipY, prevClipY);
        clipX2 = Math.min(clipX2, prevClipX + prevClipW);
        clipY2 = Math.min(clipY2, prevClipY + prevClipH);
        clipW = Math.max(0, clipX2 - clipX);
        clipH = Math.max(0, clipY2 - clipY);
        g.setClip(clipX, clipY, clipW, clipH);
        g.fillRoundRect(x0, y0, w, h, roundingD, roundingD);
        if (isActive) {
            g.setColor(85);
        } else {
            g.setColor(0x101020);
        }
        clipX = x0;
        clipY = y0;
        clipW = sliderFilledW;
        clipH = h;
        clipX2 = clipX + clipW;
        clipY2 = clipY + clipH;
        clipX = Math.max(clipX, prevClipX);
        clipY = Math.max(clipY, prevClipY);
        clipX2 = Math.min(clipX2, prevClipX + prevClipW);
        clipY2 = Math.min(clipY2, prevClipY + prevClipH);
        clipW = Math.max(0, clipX2 - clipX);
        clipH = Math.max(0, clipY2 - clipY);
        g.setClip(clipX, clipY, clipW, clipH);
        g.fillRoundRect(x0, y0, w, h, roundingD, roundingD);
        g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        this.buttonRow.setSize(-1, h / 2).setPos(x0 + w, y0 + h, 40);
        this.valueIndicator.setSize(w - this.buttonRow.w, this.buttonRow.h).setPos(x0, y0 + h, 36);
        this.title.setSize(w, h - this.buttonRow.h).setPos(x0, y0, 20);
    }

    public short getValue() {
        return this.prop.getValue();
    }

    public void setValue(int value) {
        this.value = (short)Mathh.constrain(this.minValue, value, this.maxValue);
        this.prop.setValue(this.value);
        this.valueIndicator.setText(String.valueOf(this.value));
    }

    @Override
    public boolean pointerPressed(int x, int y) {
        this.prevDraggedX = x;
        this.prevDraggedTime = System.currentTimeMillis();
        return super.pointerPressed(x, y);
    }

    @Override
    public boolean pointerDragged(int x, int y) {
        int dx = x - this.pressedX;
        int dy = y - this.pressedY;
        int dt = (int)(System.currentTimeMillis() - this.prevDraggedTime);
        if (Math.abs(dx) < Math.abs(dy * 5)) {
            this.prevDraggedX = x;
            return false;
        }
        if (dt != 0) {
            this.prevDraggedTime = System.currentTimeMillis();
            dx = Mathh.constrain(-200, x - this.prevDraggedX, 200);
            short prevValue = this.value;
            this.setValue(this.value + dx * dx * dx / dt / this.w);
            if (this.value != prevValue) {
                this.prevDraggedX = x;
            }
        }
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int count) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        switch (RootContainer.getAction(keyCode)) {
            case 5: {
                this.setValue(this.value + count * count);
                return true;
            }
            case 2: {
                this.setValue(this.value - count * count);
                return true;
            }
        }
        return super.keyPressed(keyCode, count);
    }

    @Override
    public boolean keyRepeated(int keyCode, int pressedCount) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        switch (RootContainer.getAction(keyCode)) {
            case 5: {
                this.setValue(this.value + pressedCount * pressedCount);
                return true;
            }
            case 2: {
                this.setValue(this.value - pressedCount * pressedCount);
                return true;
            }
        }
        return super.keyRepeated(keyCode, pressedCount);
    }

    @Override
    public boolean canBeFocused() {
        return true;
    }
}

