/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.Button;

public abstract class Switch
extends Button {
    private boolean value = this.getValue();
    int padding;
    private int switchW;
    int switchX0;
    protected boolean showKbHints;

    public Switch(String title) {
        super(title);
    }

    @Override
    protected void drawText(Graphics g, String text, int x0, int y0, int w, int h, boolean isSelected, boolean isFocused, boolean forceInactive, boolean showKbHints) {
        int switchFreeSpace = w / 4;
        int switchCenterX = x0 + w * 7 / 8;
        int switchH = Math.min(switchFreeSpace / 2, h * 2 / 3);
        this.switchW = Math.min(switchFreeSpace, switchH * 3);
        this.padding = this.switchW / 8;
        super.drawText(g, text, x0, y0, switchCenterX - this.switchW / 2 - x0, h, isSelected, isFocused, forceInactive, showKbHints);
        this.switchX0 = switchCenterX - this.switchW / 2 + this.padding;
        this.switchW -= this.padding * 2;
        int switchY0 = y0 + (h - switchH) / 2;
        if (this.isActive()) {
            if (this.value) {
                g.setColor(85);
            } else {
                g.setColor(0x202025);
            }
        } else {
            g.setColor(this.bgColorInactive);
        }
        g.fillRoundRect(this.switchX0, switchY0, this.switchW, switchH, this.switchW / 2, switchH);
        if (this.isActive()) {
            g.setColor(this.fontColor);
        } else {
            g.setColor(this.fontColorInactive);
        }
        int d = switchH * 4 / 5;
        int x = this.switchX0;
        if (this.value) {
            x += this.switchW - d;
        }
        g.fillArc(x, switchY0 + (switchH - d) / 2, d, d, 0, 360);
    }

    @Override
    public void buttonPressed() {
        this.value = !this.value;
        this.setValue(this.value);
    }

    public abstract boolean getValue();

    public abstract void setValue(boolean var1);
}

