/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.ui.Font;
import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.UIComponent;

public class TextComponent
extends UIComponent {
    public static final int HEIGHT_AUTO = -1;
    public static final int FONT_SIZE_AUTO = -1;
    private String text = null;
    private int fontColor;
    private int[][] lineBounds = null;
    private int prevW;
    public Font font;
    private boolean autoFontSize = true;
    private Font prevGetLineBoundsFont = this.font = Font.getDefaultFont();
    public int padding = this.font.getHeight() / 6;
    private Thread scrollAnimThread = null;
    private boolean isHorizontalScrollingEnabled = false;
    int horizontalScrollOffset = 0;
    int textW2 = 0;
    int textAlignment = 3;

    public TextComponent() {
        this.bgColor = 85;
        this.fontColor = 0xFFFFFF;
    }

    public TextComponent(String text) {
        this();
        this.setText(text);
    }

    @Override
    public void init() {
        super.init();
        this.enableHorizontalScrolling(this.isHorizontalScrollingEnabled);
    }

    private int getOptimalHeight() {
        return this.font.getHeight() * this.getLineBounds(this.text, this.font, this.w, this.padding).length + this.font.getHeight() / 2;
    }

    @Override
    public void onPaint(Graphics g, int x0, int y0, int w, int h, boolean forceSelected) {
        boolean hCenter;
        if (this.text == null) {
            return;
        }
        Font prevFont = g.getFont();
        g.setFont(this.font);
        this.lineBounds = this.getLineBounds(this.text, this.font, w, this.padding);
        int step = this.font.getHeight() * 3 / 2;
        if (step * this.lineBounds.length > h - this.padding * 2 && step * this.lineBounds.length > h - this.padding * 2) {
            step = h / this.lineBounds.length;
        }
        int offset = this.padding;
        if ((this.textAlignment & 2) != 0) {
            offset = -step * (this.lineBounds.length - 1) / 2 + h / 2 - this.font.getHeight() / 2;
        }
        boolean bl = hCenter = (this.textAlignment & 1) != 0;
        if (this.isActive && !forceSelected) {
            g.setColor(this.fontColor);
        } else {
            g.setColor(0x404040);
        }
        for (int i = 0; i < this.lineBounds.length; ++i) {
            int[] bounds = this.lineBounds[i];
            g.drawSubstring(this.text, bounds[0], bounds[1], x0 + (hCenter ? w / 2 : 0) - this.horizontalScrollOffset, y0 + offset, (hCenter ? 1 : 4) | 0x10);
            offset += step;
        }
        g.setFont(prevFont);
    }

    private int[][] getLineBounds(String text, Font font, int w, int padding) {
        if (this.isHorizontalScrollingEnabled) {
            return new int[][]{{0, text.length()}};
        }
        if (this.lineBounds != null && w == this.prevW && font.getSize() == this.prevGetLineBoundsFont.getSize()) {
            return this.lineBounds;
        }
        this.prevW = w;
        this.prevGetLineBoundsFont = font;
        return font.getLineBounds(text, w, padding);
    }

    @Override
    public boolean canBeFocused() {
        return false;
    }

    @Override
    public boolean handlePointerClicked(int x, int y) {
        return false;
    }

    @Override
    public boolean handleKeyPressed(int keyCode, int count) {
        return false;
    }

    public String getText() {
        return this.text;
    }

    public TextComponent setText(String text) {
        this.text = text;
        this.textW2 = Font.getDefaultFont().stringWidth(text) / 2;
        this.lineBounds = null;
        this.horizontalScrollOffset = 0;
        if (this.h == -1) {
            this.onSetBounds(this.x0, this.y0, this.w, this.h);
        }
        return this;
    }

    public void setFontSize(int size) {
        boolean bl = this.autoFontSize = size == -1;
        if (!this.autoFontSize) {
            this.font = new Font(size);
        }
    }

    public TextComponent setTextAlignment(int a) {
        this.textAlignment = a;
        return this;
    }

    public TextComponent setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public TextComponent enableHorizontalScrolling(boolean b) {
        if (b && this.scrollAnimThread == null) {
            this.scrollAnimThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int prevScrollOffset = TextComponent.this.horizontalScrollOffset = 0;
                    boolean reverse = false;
                    try {
                        while (TextComponent.this.isHorizontalScrollingEnabled && TextComponent.this.isOnScreen()) {
                            long start = System.currentTimeMillis();
                            if (TextComponent.this.textW2 * 2 > TextComponent.this.w) {
                                if (!reverse) {
                                    if (TextComponent.this.horizontalScrollOffset < TextComponent.this.textW2 - TextComponent.this.w / 3) {
                                        TextComponent.this.horizontalScrollOffset += TextComponent.this.textW2 / 128;
                                    } else {
                                        Thread.sleep(500L);
                                        reverse = true;
                                    }
                                } else if (TextComponent.this.horizontalScrollOffset > -TextComponent.this.textW2 + TextComponent.this.w / 3) {
                                    TextComponent.this.horizontalScrollOffset -= TextComponent.this.textW2 / 16;
                                } else {
                                    Thread.sleep(500L);
                                    reverse = false;
                                }
                                if (TextComponent.this.horizontalScrollOffset != prevScrollOffset) {
                                    TextComponent.this.repaint();
                                }
                            } else {
                                TextComponent.this.horizontalScrollOffset = 0;
                            }
                            prevScrollOffset = TextComponent.this.horizontalScrollOffset;
                            Thread.sleep(Math.max(0L, 20L - (System.currentTimeMillis() - start)));
                        }
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    TextComponent.this.scrollAnimThread = null;
                }
            });
            this.scrollAnimThread.start();
        }
        this.isHorizontalScrollingEnabled = b;
        return this;
    }

    @Override
    public void onSetBounds(int x0, int y0, int w, int h) {
        this.x0 = x0;
        this.y0 = y0;
        this.w = w;
        this.h = h;
        if (h == -1 && this.text != null) {
            this.h = this.getOptimalHeight();
        }
        if (this.autoFontSize) {
            this.font = new Font(Font.getDefaultFontSize());
            this.lineBounds = this.getLineBounds(this.text, this.font, w, this.padding);
            if (h / this.lineBounds.length < this.font.getHeight()) {
                this.font = new Font(0);
                this.lineBounds = this.getLineBounds(this.text, this.font, w, this.padding);
                if (h / this.lineBounds.length < this.font.getHeight()) {
                    this.font = new Font(8);
                    this.lineBounds = this.getLineBounds(this.text, this.font, w, this.padding);
                }
            }
        }
    }
}

