/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.ui;

import mobileapplication3.platform.ui.Graphics;
import mobileapplication3.ui.IContainer;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.UISettings;

public abstract class UIComponent
implements IUIComponent {
    protected boolean isVisible = true;
    protected boolean isFocused = false;
    protected boolean isActive = true;
    public int x0;
    public int y0;
    public int w;
    public int h;
    public int prevX0;
    public int prevY0;
    public int prevW;
    public int prevH;
    public int anchorX0;
    public int anchorY0;
    public int anchor = 20;
    private boolean isSizeSet = false;
    protected int bgColor = -1;
    private boolean roundBg = true;
    private int padding;
    private IContainer parent = null;

    @Override
    public final void paint(Graphics g) {
        this.paint(g, false);
    }

    @Override
    public final void paint(Graphics g, boolean forceInactive) {
        this.paint(g, this.x0, this.y0, this.w, this.h, forceInactive);
    }

    @Override
    public final void paint(Graphics g, int x0, int y0, int w, int h) {
        this.paint(g, x0, y0, w, h, false);
    }

    @Override
    public final void paint(Graphics g, int x0, int y0, int w, int h, boolean forceInactive) {
        if (this.isVisible) {
            int prevClipX = g.getClipX();
            int prevClipY = g.getClipY();
            int prevClipW = g.getClipWidth();
            int prevClipH = g.getClipHeight();
            if (w <= 0 || h <= 0) {
                return;
            }
            int clipX = x0 + this.padding;
            int clipY = y0 + this.padding;
            int clipW = w - this.padding * 2;
            int clipH = h - this.padding * 2;
            int clipX2 = clipX + clipW;
            int clipY2 = clipY + clipH;
            clipX = Math.max(clipX, prevClipX);
            clipY = Math.max(clipY, prevClipY);
            clipX2 = Math.min(clipX2, prevClipX + prevClipW);
            clipY2 = Math.min(clipY2, prevClipY + prevClipH);
            clipW = Math.max(0, clipX2 - clipX);
            clipH = Math.max(0, clipY2 - clipY);
            g.setClip(clipX, clipY, clipW, clipH);
            this.setBounds(x0, y0, w, h);
            this.drawBg(g, x0 + this.padding, y0 + this.padding, w - this.padding * 2, h - this.padding * 2, this.isActive && !forceInactive);
            this.onPaint(g, x0 + this.padding, y0 + this.padding, w - this.padding * 2, h - this.padding * 2, forceInactive);
            g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
        }
    }

    public void drawBg(Graphics g, int x0, int y0, int w, int h, boolean IsActive) {
        int bgColor = this.isActive ? this.bgColor : 0x202025;
        if (bgColor >= 0) {
            g.setColor(bgColor);
            if (this.roundBg) {
                int d = Math.min(w / 5, h / 5);
                g.fillRoundRect(x0, y0, w, h, d, d);
            } else {
                g.fillRect(x0, y0, w, h);
            }
        }
    }

    @Override
    public boolean checkTouchEvent(int x, int y) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        if (x < this.x0 || y < this.y0) {
            return false;
        }
        return x - this.x0 <= this.w && y - this.y0 <= this.h;
    }

    @Override
    public IUIComponent setVisible(boolean b) {
        this.isVisible = b;
        return this;
    }

    @Override
    public IUIComponent setFocused(boolean b) {
        this.isFocused = b;
        return this;
    }

    @Override
    public IUIComponent setActive(boolean b) {
        this.isActive = b;
        return this;
    }

    @Override
    public boolean getIsVisible() {
        return this.isVisible;
    }

    @Override
    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean repaintOnlyOnFlushGraphics() {
        return false;
    }

    public boolean toggleIsVisible() {
        this.setVisible(!this.isVisible);
        return this.isVisible;
    }

    public void recalcSize() {
        this.setSize(this.w, this.h);
    }

    public void recalcPos() {
        this.setPos(this.anchorX0, this.anchorY0, this.anchor);
    }

    @Override
    public IUIComponent setPos(int x0, int y0, int anchor) {
        this.anchorX0 = x0;
        this.anchorY0 = y0;
        this.anchor = anchor;
        if ((anchor & 8) != 0) {
            x0 -= this.w;
        } else if ((anchor & 1) != 0) {
            x0 -= this.w / 2;
        }
        if ((anchor & 0x20) != 0) {
            y0 -= this.h;
        } else if ((anchor & 2) != 0) {
            y0 -= this.h / 2;
        }
        this.setBounds(x0, y0, this.w, this.h);
        return this;
    }

    @Override
    public IUIComponent setSize(int w, int h) {
        if (w == 0 || h == 0) {
            try {
                throw new Exception("Setting zero as a dimension " + this.getClass().getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this;
            }
        }
        this.w = w;
        this.h = h;
        this.recalcPos();
        return this;
    }

    private final void setBounds(int x0, int y0, int w, int h) {
        if (x0 == this.prevX0 && y0 == this.prevY0 && w == this.prevW && h == this.prevH) {
            return;
        }
        this.prevW = this.w = w;
        this.prevH = this.h = h;
        this.prevX0 = this.x0 = x0;
        this.prevY0 = this.y0 = y0;
        this.onSetBounds(x0, y0, w, h);
        this.isSizeSet = true;
    }

    protected void onSetBounds(int x0, int y0, int w, int h) {
    }

    @Override
    public IUIComponent setBgColor(int color) {
        this.bgColor = color;
        return this;
    }

    @Override
    public IUIComponent setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public IUIComponent roundBg(boolean b) {
        this.roundBg = b;
        return this;
    }

    public int getLeftX() {
        return this.x0;
    }

    public int getRightX() {
        return this.x0 + this.w;
    }

    public int getTopY() {
        return this.y0;
    }

    public int getBottomY() {
        return this.y0 + this.h;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public boolean isSizeSet() {
        return this.isSizeSet;
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public IUIComponent setParent(IContainer parent) {
        this.parent = parent;
        return this;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public UISettings getUISettings() {
        if (this.hasParent()) {
            return this.parent.getUISettings();
        }
        try {
            throw new IllegalStateException(this.getClass().getName() + " has no parent and can't get UI settings");
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint();
        } else {
            try {
                throw new NullPointerException("Can't call parent's repaint: parent component is not set! " + this.getClass().getName());
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Graphics getUGraphics() {
        if (this.parent != null) {
            return this.parent.getUGraphics();
        }
        try {
            throw new NullPointerException("Can't call parent's getGraphics: parent component is not set! " + this.getClass().getName());
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void flushGraphics() {
        if (this.parent != null) {
            this.parent.flushGraphics();
        } else {
            try {
                throw new NullPointerException("Can't call parent's getGraphics: parent component is not set! " + this.getClass().getName());
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isOnScreen() {
        return this.hasParent() && this.parent.isOnScreen();
    }

    @Override
    public void onShow() {
    }

    @Override
    public void onHide() {
    }

    @Override
    public boolean pointerReleased(int x, int y) {
        if (!this.isVisible || !this.checkTouchEvent(x, y)) {
            return false;
        }
        return this.handlePointerReleased(x, y);
    }

    @Override
    public boolean pointerClicked(int x, int y) {
        if (!this.isVisible || !this.checkTouchEvent(x, y)) {
            return false;
        }
        return this.handlePointerClicked(x, y);
    }

    @Override
    public boolean pointerDragged(int x, int y) {
        if (!this.isVisible || !this.checkTouchEvent(x, y)) {
            return false;
        }
        return this.handlePointerDragged(x, y);
    }

    @Override
    public boolean pointerPressed(int x, int y) {
        if (!this.isVisible || !this.checkTouchEvent(x, y)) {
            return false;
        }
        return this.handlePointerPressed(x, y);
    }

    @Override
    public boolean keyPressed(int keyCode, int count) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        return this.handleKeyPressed(keyCode, count);
    }

    @Override
    public boolean keyRepeated(int keyCode, int pressedCount) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        return this.handleKeyRepeated(keyCode, pressedCount);
    }

    @Override
    public boolean keyReleased(int keyCode, int count) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        return this.handleKeyReleased(keyCode, count);
    }

    @Override
    public boolean mouseEvent(int event, int x, int y) {
        if (!this.isActive || !this.isVisible) {
            return false;
        }
        return this.handleMouseEvent(event, x, y);
    }

    protected boolean handleMouseEvent(int event, int x, int y) {
        return false;
    }

    protected boolean handleKeyReleased(int keyCode, int pressedCount) {
        return false;
    }

    protected boolean handleKeyRepeated(int keyCode, int pressedCount) {
        return false;
    }

    protected boolean handlePointerReleased(int x, int y) {
        return false;
    }

    protected boolean handlePointerDragged(int x, int y) {
        return false;
    }

    protected boolean handlePointerPressed(int x, int y) {
        return false;
    }

    protected abstract boolean handlePointerClicked(int var1, int var2);

    protected abstract boolean handleKeyPressed(int var1, int var2);

    protected abstract void onPaint(Graphics var1, int var2, int var3, int var4, int var5, boolean var6);
}

