/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.Platform;
import mobileapplication3.platform.Utils;
import utils.GameFileUtils;

public class MgStruct {
    static int[] argsNumber = new int[]{0, 2, 4, 7, 9, 10, 6, 8, 6, 2, 5, 5};
    static final int STRUCTURE_STORAGE_SIZE = 32;
    public static short[][][] structStorage = new short[32][][];
    public static int loadedStructsNumber = 0;
    static boolean isInited = false;
    public static int loadedFromResNumber = 0;
    public boolean loadCancelled = false;

    public MgStruct() {
        Logger.log("MGStruct constructor");
        if (!isInited) {
            Logger.log("mgs init");
            int i = 1;
            while (this.readRes("/s" + i + ".mgstruct")) {
                Logger.log(i + ".mgstruct");
                ++i;
            }
            Logger.log("MGStruct:loaded " + loadedStructsNumber);
            loadedFromResNumber = loadedStructsNumber;
        }
        Logger.log("inited");
        isInited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readRes(String path) {
        InputStream is = null;
        try {
            is = Platform.getResource(path);
            DataInputStream dis = new DataInputStream(is);
            try {
                this.saveStructToStorage(MgStruct.readFromDataInputStream(dis));
            }
            finally {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            Logger.log(path + " " + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean loadFromFiles() {
        Logger.log("mgs load()");
        this.loadCancelled = false;
        String[] paths = GameFileUtils.listFilesInAllPlaces("MobappGame/MGStructs");
        int loadedFromFiles = 0;
        loadedStructsNumber = loadedFromResNumber;
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            DataInputStream dis = null;
            try {
                dis = FileUtils.fileToDataInputStream(path);
            }
            catch (SecurityException sex) {
                Logger.log("mgs:load cancelled");
                sex.printStackTrace();
                this.loadCancelled = true;
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
            catch (NoClassDefFoundError err) {
                Platform.showError(err);
                return false;
            }
            if (dis == null) continue;
            try {
                short[][] structure = MgStruct.readFromDataInputStream(dis);
                if (structure != null) {
                    this.saveStructToStorage(structure);
                    ++loadedFromFiles;
                    Logger.log(path + " loaded");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                dis.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (loadedFromFiles > 0) {
            this.loadCancelled = false;
            loadedStructsNumber = loadedFromResNumber + loadedFromFiles;
        } else {
            loadedStructsNumber = loadedFromResNumber;
        }
        Logger.log("mg:loaded: " + loadedFromFiles);
        return loadedFromFiles > 0;
    }

    public static short[][] readFromDataInputStream(DataInputStream dis) throws IOException {
        if (dis == null) {
            return null;
        }
        try {
            short fileFormatVersion = dis.readShort();
            if (Utils.isArrContain(GameFileUtils.SUPPORTED_FILE_FORMAT_VERSIONS, fileFormatVersion)) {
                short id;
                int length = 16;
                if (fileFormatVersion > 0) {
                    length = dis.readShort();
                }
                Logger.log("read: ver=" + fileFormatVersion + " length=" + length);
                short[][] structure = new short[length][];
                int c = 0;
                while ((id = dis.readShort()) != 0) {
                    short[] data = new short[argsNumber[id] + 1];
                    data[0] = id;
                    try {
                        for (int i = 1; i < data.length; ++i) {
                            data[i] = dis.readShort();
                        }
                    }
                    catch (EOFException ex) {
                        try {
                            dis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ex;
                    }
                    structure[c] = data;
                    ++c;
                }
                try {
                    dis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return structure;
            }
            Logger.log("Unsupported file format version: " + fileFormatVersion);
            try {
                dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Logger.log("error parsing file " + ex);
            ex.printStackTrace();
            try {
                dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    void saveStructToStorage(short[][] data) {
        Logger.log("savivg new structure, id=" + loadedStructsNumber);
        structStorage = this.increaseArrayIfNeeded(structStorage, loadedStructsNumber, 8);
        MgStruct.structStorage[MgStruct.loadedStructsNumber] = data;
        ++loadedStructsNumber;
    }

    short[][][] increaseArrayIfNeeded(short[][][] array, int newElementIndex, int inc) {
        if (newElementIndex >= array.length) {
            short[][][] newArray = new short[array.length + inc][][];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }
}

