/*
 * Decompiled with CFR 0.152.
 */
package utils;

import mobileapplication3.game.GraphicsWorld;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Settings;

public class MobappGameSettings {
    private static final String RECORD_STORE_SETTINGS = "gamesettings";
    private static final String GRAPHICS_FOR_HIRES = "btrGr";
    private static final String LANDSCAPE_COLOR = "landscapeCol";
    private static final String LEGACY_DRAWING_METHOD = "oldDrawing";
    private static final String PHYSICS_PRECISION = "PhyPrecision";
    private static final String DETAIL_LEVEL = "DetailLvl";
    private static final String FRAME_TIME = "FrameTime";
    private static final String SHOW_FPS = "showFPS";
    private static final String SHOW_BG = "enBG";
    private static final String BATTERY_INDICATOR = "Batt";
    public static final int DYNAMIC_PHYSICS_PRECISION = -1;
    public static final int AUTO_PHYSICS_PRECISION = 0;
    public static final int DEFAULT_PHYSICS_PRECISION = 0;
    public static final int DEFAULT_DETAIL_LEVEL = 1;
    public static final int DEFAULT_FRAME_TIME = 16;
    public static final int MAX_PHYSICS_PRECISION = 16;
    public static final int MAX_DETAIL_LEVEL = 3;
    public static final int MAX_FRAME_TIME = 100;
    private static String mgstructsFolderPath = null;
    private static String detailLevel = "";
    private static Settings settingsInst = null;

    private MobappGameSettings() {
    }

    private static Settings getSettingsInst() {
        if (settingsInst == null) {
            settingsInst = new Settings(new String[]{GRAPHICS_FOR_HIRES, LANDSCAPE_COLOR, LEGACY_DRAWING_METHOD, PHYSICS_PRECISION, DETAIL_LEVEL, FRAME_TIME, SHOW_FPS, SHOW_BG, BATTERY_INDICATOR}, RECORD_STORE_SETTINGS);
        }
        return settingsInst;
    }

    public static boolean isBattIndicatorEnabled() {
        return MobappGameSettings.getSettingsInst().getBool(BATTERY_INDICATOR);
    }

    public static boolean isBattIndicatorEnabled(boolean defaultValue) {
        return MobappGameSettings.getSettingsInst().getBool(BATTERY_INDICATOR, defaultValue);
    }

    public static void setBattIndicatorEnabled(boolean b) {
        MobappGameSettings.getSettingsInst().set(BATTERY_INDICATOR, b);
    }

    public static boolean toggleBattIndicator() {
        return MobappGameSettings.getSettingsInst().toggleBool(BATTERY_INDICATOR);
    }

    public static boolean isBGEnabled() {
        return MobappGameSettings.getSettingsInst().getBool(SHOW_BG);
    }

    public static boolean isBGEnabled(boolean defaultValue) {
        return MobappGameSettings.getSettingsInst().getBool(SHOW_BG, defaultValue);
    }

    public static void setBGEnabled(boolean b) {
        MobappGameSettings.getSettingsInst().set(SHOW_BG, b);
    }

    public static boolean toggleBG() {
        return MobappGameSettings.getSettingsInst().toggleBool(SHOW_BG);
    }

    public static boolean isFPSShown() {
        return MobappGameSettings.getSettingsInst().getBool(SHOW_FPS);
    }

    public static boolean isFPSShown(boolean defaultValue) {
        return MobappGameSettings.getSettingsInst().getBool(SHOW_FPS, defaultValue);
    }

    public static void setFPSShown(boolean b) {
        MobappGameSettings.getSettingsInst().set(SHOW_FPS, b);
    }

    public static boolean toggleFPSShown() {
        return MobappGameSettings.getSettingsInst().toggleBool(SHOW_FPS);
    }

    public static boolean isBetterGraphicsEnabled() {
        return MobappGameSettings.getSettingsInst().getBool(GRAPHICS_FOR_HIRES);
    }

    public static boolean isBetterGraphicsEnabled(boolean defaultValue) {
        return MobappGameSettings.getSettingsInst().getBool(GRAPHICS_FOR_HIRES, defaultValue);
    }

    public static void setBetterGraphicsEnabled(boolean b) {
        MobappGameSettings.getSettingsInst().set(GRAPHICS_FOR_HIRES, b);
    }

    public static boolean toggleBetterGraphics() {
        return MobappGameSettings.getSettingsInst().toggleBool(GRAPHICS_FOR_HIRES);
    }

    public static int getLandscapeColor() {
        return MobappGameSettings.getSettingsInst().getInt(LANDSCAPE_COLOR, GraphicsWorld.DEFAULT_LANDSCAPE_COLOR);
    }

    public static void setLandscapeColor(int value) {
        MobappGameSettings.getSettingsInst().set(LANDSCAPE_COLOR, String.valueOf(value));
    }

    public static int getPhysicsPrecision() {
        return MobappGameSettings.getSettingsInst().getInt(PHYSICS_PRECISION, 0);
    }

    public static void setPhysicsPrecision(int value) {
        MobappGameSettings.getSettingsInst().set(PHYSICS_PRECISION, String.valueOf(value));
    }

    public static int getDetailLevel() {
        int value;
        if (detailLevel.equals("")) {
            value = MobappGameSettings.getSettingsInst().getInt(DETAIL_LEVEL, 1);
            detailLevel = String.valueOf(value);
        } else {
            value = Integer.valueOf(detailLevel);
        }
        return value;
    }

    public static void setDetailLevel(int value) {
        detailLevel = String.valueOf(value);
        MobappGameSettings.getSettingsInst().set(DETAIL_LEVEL, String.valueOf(value));
    }

    public static int getFrameTime() {
        return Mathh.constrain(1, MobappGameSettings.getSettingsInst().getInt(FRAME_TIME, 16), 100);
    }

    public static void setFrameTime(int valueMs) {
        MobappGameSettings.getSettingsInst().set(FRAME_TIME, String.valueOf(Mathh.constrain(1, valueMs, 100)));
    }

    public static boolean isLegacyDrawingMethodEnabled() {
        return MobappGameSettings.getSettingsInst().getBool(LEGACY_DRAWING_METHOD);
    }

    public static boolean isLegacyDrawingMethodEnabled(boolean defaultValue) {
        return MobappGameSettings.getSettingsInst().getBool(LEGACY_DRAWING_METHOD, defaultValue);
    }

    public static void setLegacyDrawingMethodEnabled(boolean b) {
        MobappGameSettings.getSettingsInst().set(LEGACY_DRAWING_METHOD, b);
    }

    public static boolean toggleLegacyDrawingMethod() {
        return MobappGameSettings.getSettingsInst().toggleBool(LEGACY_DRAWING_METHOD);
    }
}

